﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Threading

Public Class MainForm

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load
        ' 追加当前线程的 ID
        ThreadID.Text &= CStr(Thread.CurrentThread.ManagedThreadId)

    End Sub

    Private Sub theLongRunningTask()
        Dim progressForm As New TaskProgress()
        progressForm.Show()
        ' 刷新引起标签的即时（非发布）显示。
        progressForm.Refresh()

        ' 缓慢递增进度栏。
        For i As Integer = 1 To 10
            progressForm.ProgressIndicator.Value += 10
            ' 半秒延迟
            System.Threading.Thread.Sleep(500)
        Next

        ' 在“任务”结束后移除窗体。
        progressForm.Hide()
        progressForm.Dispose()

    End Sub

    Private Sub SameThread_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SameThread.Click
        ' 在管理 frmMain 窗口的同一线程上运行任务。
        theLongRunningTask()
    End Sub

    ' 若要在辅助池线程上运行任务，可以对委托使用
    ' 异步调用。在本例中，我们将声明一个名为 TaskDelegate 的
    ' 委托，然后异步调用该委托。委托声明的签名
    ' 必须与方法 (TheLongRunningTask) 完全匹配。
    Delegate Sub TaskDelegate()

    Private Sub ThreadPool_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ThreadPool.Click
        ' 若要在辅助池的线程上运行任务，请创建一个委托的实例，
        ' 其中委托的签名与将要调用的方法匹配，
        ' 然后对该委托调用 BeginInvoke。在本例中，不需要
        ' BeginInvoke 的参数和返回值。此技术有时
        ' 称为“发后不理”(Fire and Forget)。

        Dim td As New TaskDelegate(AddressOf theLongRunningTask)
        ' 在池的辅助线程上运行。
        td.BeginInvoke(Nothing, Nothing)
    End Sub

    Private Sub BackgroundWorker_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BackgroundWorker.Click
        ' 使用新的 BackgroundWorker 组件在辅助池的线程上运行任务，
        ' 该组件将通过 RunWorkerCompleted 事件
        ' 自动将结果封送回主用户界面线程
        Worker.RunWorkerAsync()
    End Sub

    Private Sub Worker_DoWork(ByVal sender As Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles Worker.DoWork
        ' 此事件在后台线程上激发，我们在此处对长时间运行
        ' 的任务进行调用
        theLongRunningTask()
    End Sub

    Private Sub exitToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
